/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPQname;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.CharacterModel;
import com.hp.hpl.jena.rdf.arp.DefaultErrorHandler;
import com.hp.hpl.jena.rdf.arp.ExceptionToken;
import com.hp.hpl.jena.rdf.arp.ExtendedHandler;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.ParserSupport;
import com.hp.hpl.jena.rdf.arp.RDFParser;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.TokenPipe;
import com.hp.hpl.jena.rdf.arp.Warn;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import com.hp.hpl.jena.rdf.arp.XMLNullContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xni.parser.XMLPullParserConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

class ARPFilter
extends XMLFilterImpl
implements RDFParserConstants,
ARPErrorNumbers,
LexicalHandler {
    private XMLPullParserConfiguration pullParser;
    private SAXParser saxParser;
    private Map nodeIdUserData;
    private boolean embedding = false;
    private String readerXMLEncoding = null;
    private String xmlEncoding = null;
    boolean encodingProblems = false;
    private NamespaceHandler nameHandler = new NamespaceHandler(){

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }
    };
    static ExtendedHandler nullScopeHandler;
    ExtendedHandler scopeHandler = nullScopeHandler;
    StatementHandler statementHandler = new StatementHandler(){

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
        }
    };
    XMLContext documentContext;
    private TokenPipe pipe;
    private Locator locator;
    static final String rdfns;
    static final String xmlns;
    static final Map rdfnames;
    static final Set knownRDFProperties;
    static final Set knownRDFTypes;
    static final Set knownBadRDFNames;
    private static String[] specialAtts;
    private static String[] specialNameSpaces;
    private static int[] specialAttValues;
    private static int[] defaultErrorMode;
    private int[] errorMode = (int[])defaultErrorMode.clone();

    private ARPFilter(SAXParser sAXParser, XMLPullParserConfiguration xMLPullParserConfiguration) {
        super((XMLReader)sAXParser);
        this.pullParser = xMLPullParserConfiguration;
        this.saxParser = sAXParser;
        sAXParser.setEntityResolver((EntityResolver)this);
        sAXParser.setDTDHandler((DTDHandler)this);
        sAXParser.setContentHandler((ContentHandler)this);
        sAXParser.setErrorHandler((ErrorHandler)this);
        this.setErrorHandler(new DefaultErrorHandler());
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        this.nameHandler.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        this.nameHandler.endPrefixMapping(string);
    }

    void userWarning(ParseException parseException) throws SAXException {
        this.getErrorHandler().warning(parseException.rootCause());
    }

    void userError(ParseException parseException) throws SAXException {
        if (parseException.getFatal()) {
            this.getErrorHandler().fatalError(parseException.rootCause());
        } else {
            this.getErrorHandler().error(parseException.rootCause());
        }
    }

    static ARPFilter create() {
        ARPFilter aRPFilter;
        StandardParserConfiguration standardParserConfiguration = new StandardParserConfiguration();
        MySAXParser mySAXParser = new MySAXParser(standardParserConfiguration);
        mySAXParser.a = aRPFilter = new ARPFilter(mySAXParser, (XMLPullParserConfiguration)standardParserConfiguration);
        return aRPFilter;
    }

    boolean setEmbedding(boolean bl) {
        boolean bl2 = this.embedding;
        this.embedding = bl;
        return bl2;
    }

    XMLInputSource convert(InputSource inputSource) {
        Reader reader = inputSource.getCharacterStream();
        InputStream inputStream = inputSource.getByteStream();
        String string = inputSource.getPublicId();
        String string2 = inputSource.getSystemId();
        this.readerXMLEncoding = null;
        this.encodingProblems = false;
        if (reader == null && inputStream == null) {
            return new XMLInputSource(string, string2, string2);
        }
        if (reader == null) {
            return new XMLInputSource(string, string2, string2, inputStream, null);
        }
        if (inputStream == null) {
            if (reader instanceof InputStreamReader) {
                String string3 = ((InputStreamReader)reader).getEncoding();
                this.readerXMLEncoding = EncodingMap.getJava2IANAMapping((String)string3);
                if (this.readerXMLEncoding == null) {
                    this.readerXMLEncoding = string3;
                }
            }
            return new XMLInputSource(string, string2, string2, reader, null);
        }
        return null;
    }

    boolean parseSome() {
        try {
            return this.pullParser.parse(false);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            this.generalError(212, uTFDataFormatException);
            return false;
        }
        catch (IOException iOException) {
            this.generalError(213, iOException);
            return false;
        }
        catch (DontDieYetException dontDieYetException) {
            return false;
        }
    }

    public void setEncoding(String string) {
        if ((string = string.toUpperCase()) != null && this.xmlEncoding == null) {
            if (string.equals("UTF") && this.readerXMLEncoding != null && this.readerXMLEncoding.startsWith("UTF")) {
                this.xmlEncoding = this.readerXMLEncoding;
                return;
            }
            this.xmlEncoding = string;
            if (this.readerXMLEncoding != null && !this.readerXMLEncoding.equals(string)) {
                this.putWarning(129, new Location(this.locator), "Encoding on InputStreamReader or FileReader does not match that of XML document. Use FileInputStream. [" + this.readerXMLEncoding + " != " + string + "]");
                this.encodingProblems = true;
            }
        }
    }

    Locator getLocator() {
        return this.pipe == null ? null : this.pipe.getLocator();
    }

    public synchronized void parse(InputSource inputSource) throws IOException, SAXException {
        this.parse(inputSource, inputSource.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(InputSource inputSource, String string) throws IOException, SAXException {
        block14: {
            Iterator iterator;
            this.nodeIdUserData = new HashMap();
            if (string == null) {
                this.warning(5, "Base URI not specified for input file; local URI references will be in error.");
                this.documentContext = new XMLNullContext(this, 211);
            } else if (string.equals("")) {
                this.warning(5, "Base URI specified as \"\"; local URI references will not be resolved.");
                this.documentContext = new XMLNullContext(this, 130);
            } else {
                string = ParserSupport.truncateXMLBase(string);
                this.documentContext = new XMLContext(string);
            }
            this.pipe = new TokenPipe(this);
            this.pullParser.setInputSource(this.convert(inputSource));
            this.saxParser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.saxParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
            this.saxParser.reset();
            try {
                try {
                    RDFParser rDFParser = new RDFParser(this.pipe, this);
                    if (this.embedding) {
                        rDFParser.embeddedFile(this.documentContext);
                    } else {
                        rDFParser.rdfFile(this.documentContext);
                    }
                }
                catch (WrappedException wrappedException) {
                    wrappedException.throwMe();
                }
                catch (ParseException parseException) {
                    throw parseException.rootCause();
                }
                Object var5_6 = null;
                if (this.scopeHandler == nullScopeHandler) break block14;
                iterator = this.nodeIdUserData.keySet().iterator();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (this.scopeHandler != nullScopeHandler) {
                    Iterator iterator2 = this.nodeIdUserData.keySet().iterator();
                    while (iterator2.hasNext()) {
                        String string2 = (String)iterator2.next();
                        ARPResource aRPResource = new ARPResource(this);
                        aRPResource.setNodeId(string2);
                        this.scopeHandler.endBNodeScope(aRPResource);
                    }
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                ARPResource aRPResource = new ARPResource(this);
                aRPResource.setNodeId(string3);
                this.scopeHandler.endBNodeScope(aRPResource);
            }
        }
    }

    NamespaceHandler setNamespaceHandler(NamespaceHandler namespaceHandler) {
        NamespaceHandler namespaceHandler2 = this.nameHandler;
        this.nameHandler = namespaceHandler;
        return namespaceHandler2;
    }

    ExtendedHandler setExtendedHandler(ExtendedHandler extendedHandler) {
        ExtendedHandler extendedHandler2 = this.scopeHandler;
        this.scopeHandler = extendedHandler;
        return extendedHandler2;
    }

    StatementHandler setStatementHandler(StatementHandler statementHandler) {
        StatementHandler statementHandler2 = this.statementHandler;
        this.statementHandler = statementHandler;
        return statementHandler2;
    }

    private void warning(int n, String string) {
        try {
            switch (this.errorMode[n]) {
                case 0: {
                    break;
                }
                case 1: {
                    this.getErrorHandler().warning(new ParseException(n, string));
                    break;
                }
                case 2: {
                    this.getErrorHandler().error(new ParseException(n, string));
                    break;
                }
                case 3: {
                    this.getErrorHandler().fatalError(new ParseException(n, string));
                }
            }
        }
        catch (SAXException sAXException) {
            throw new WrappedException(sAXException);
        }
    }

    void setDefaultErrorMode() {
        this.errorMode = (int[])defaultErrorMode.clone();
    }

    void setLaxErrorMode() {
        this.setDefaultErrorMode();
        for (int i = 100; i < 200; ++i) {
            this.setErrorMode(i, 0);
        }
        this.setErrorMode(112, 1);
    }

    void setStrictErrorMode() {
        this.setStrictErrorMode(0);
    }

    void setStrictErrorMode(int n) {
        int n2;
        this.setDefaultErrorMode();
        for (n2 = 1; n2 < 100; ++n2) {
            this.setErrorMode(n2, n);
        }
        n2 = 1;
        int n4 = 2;
        switch (n) {
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n4 = 3;
                n2 = 3;
            }
        }
        for (int i = 100; i < 200; ++i) {
            this.setErrorMode(i, n4);
        }
        this.setErrorMode(112, n2);
        this.setErrorMode(112, n2);
        this.setErrorMode(117, n2);
        this.setErrorMode(131, n2);
        this.setErrorMode(106, n2);
        this.setErrorMode(119, n);
        this.setErrorMode(120, n);
        this.setErrorMode(114, n);
        this.setErrorMode(113, n2);
        this.setErrorMode(103, n2);
        this.setErrorMode(101, n2);
        this.setErrorMode(118, n);
        this.setErrorMode(126, n2);
        this.setErrorMode(4, n4);
    }

    int setErrorMode(int n, int n2) {
        int n4 = this.errorMode[n];
        block0 : switch (n2) {
            case 0: 
            case 1: {
                if (n >= 200 && n != 202) break;
            }
            case 2: 
            case 3: {
                switch (n) {
                    case 300: {
                        break block0;
                    }
                }
                this.errorMode[n] = n2;
            }
        }
        return n4;
    }

    void parseWarning(int n, Location location, String string) throws ParseException {
        this.parseWarning(n, location, string, null);
    }

    void parseWarning(int n, Location location, String string, SAXParseException sAXParseException) throws ParseException {
        int n2 = this.errorMode[n];
        if (n2 == 0) {
            return;
        }
        ParseException parseException = new ParseException(n, location, string, sAXParseException);
        if (n2 == 3) {
            parseException.setFatal(true);
            n2 = 2;
        }
        if (n2 == 2) {
            throw parseException;
        }
        try {
            this.userWarning(parseException);
            return;
        }
        catch (ParseException parseException2) {
            if (parseException2 == parseException) {
                throw parseException2;
            }
            throw new WrappedException(parseException);
        }
        catch (SAXException sAXException) {
            throw new WrappedException(sAXException);
        }
    }

    void parseWarning(Warn warn) throws ParseException {
        this.parseWarning(warn.number, warn.location, warn.msg);
    }

    private void putWarning(int n, Location location, String string) {
        this.pipe.putNextToken(new Warn(n, location, string));
    }

    void setUserData(String string, Object object) {
        this.nodeIdUserData.put(string, object);
    }

    Object getUserData(String string) {
        return this.nodeIdUserData.get(string);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    private void doSpecialAtt(int n, int n2, String string, BitSet bitSet, Attributes attributes, Location location) throws SAXException {
        bitSet.set(n);
        if (n2 == 25) {
            return;
        }
        this.pipe.putNextToken(new ARPQname(n2, location, string, null, attributes.getQName(n)));
        String string2 = attributes.getValue(n);
        if (n2 == 18) {
            if (string2.equals("Resource")) {
                this.pipe.putNextToken(new StrToken(22, location, string2));
            } else if (string2.equals("Collection")) {
                this.pipe.putNextToken(new StrToken(21, location, string2));
            } else if (string2.equals("daml:collection") && this.errorMode[125] != 2) {
                this.pipe.putNextToken(new StrToken(20, location, string2));
                this.putWarning(4, location, "Illegal parseType: " + string2);
            } else {
                this.pipe.putNextToken(new StrToken(19, location, string2));
                if (!string2.equals("Literal")) {
                    this.putWarning(106, location, "Unknown parseType: " + string2);
                }
            }
        } else {
            this.pipe.putNextToken(new StrToken(11, location, string2));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        int n;
        Location location = new Location(this.locator);
        this.putElementQname(string, string2, string3, location);
        BitSet bitSet = new BitSet();
        for (n = 0; n < attributes.getLength(); ++n) {
            String string5 = attributes.getQName(n);
            if (!string5.startsWith("xmlns")) continue;
            string4 = "";
            if (!string5.equals("xmlns")) {
                if (string5.charAt(5) != ':') continue;
                string4 = string5.substring(6);
            }
            bitSet.set(n);
            this.pipe.putNextToken(new StrToken(26, location, string4));
            String string6 = attributes.getValue(n);
            this.pipe.putNextToken(new StrToken(11, location, string6));
            if (string6.startsWith(rdfns) && !string6.equals(rdfns)) {
                this.putWarning(127, location, "Namespace URI ref " + string6 + " may not be used in RDF/XML.");
            }
            if (!string6.startsWith(xmlns) || string6.equals(xmlns)) continue;
            this.putWarning(128, location, "Namespace URI ref " + string6 + " may not be used in RDF/XML.");
        }
        for (n = 0; n < specialAtts.length; ++n) {
            int n2 = attributes.getIndex(specialNameSpaces[n], specialAtts[n]);
            if (n2 != -1) {
                this.doSpecialAtt(n2, specialAttValues[n], specialNameSpaces[n], bitSet, attributes, location);
            }
            if (specialNameSpaces[n] != rdfns || (n2 = attributes.getIndex("", specialAtts[n])) == -1) continue;
            this.putWarning(101, location, "Unqualified use of rdf:" + attributes.getLocalName(n2) + " has been deprecated.");
            this.doSpecialAtt(n2, specialAttValues[n], "", bitSet, attributes, location);
        }
        for (n = 0; n < attributes.getLength(); ++n) {
            if (bitSet.get(n)) continue;
            String string7 = attributes.getURI(n);
            string4 = attributes.getQName(n);
            if (string4.length() >= 3 && string4.substring(0, 3).toLowerCase().equals("xml")) {
                this.putWarning(118, location, "XML attribute: " + attributes.getQName(n) + " is not known and is being discarded.");
                continue;
            }
            if (string7.equals("")) {
                this.putWarning(102, location, "Attribute: " + attributes.getLocalName(n) + ". Unqualified use is deprecated. Assuming namespace: " + string);
                string7 = string;
            }
            this.putAttributeQname(string7, attributes.getLocalName(n), string4, location);
            this.pipe.putNextToken(new StrToken(11, location, attributes.getValue(n)));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new Token(6, location));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(1, location, new String(cArray, n, n2)));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    private boolean isMemberProperty(String string) {
        if (string.startsWith("_")) {
            String string2 = string.substring(1);
            if (string2.startsWith("-") || string2.startsWith("0")) {
                return false;
            }
            try {
                Integer.parseInt(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    new BigInteger(string2);
                    return true;
                }
                catch (NumberFormatException numberFormatException2) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isKnownRDFProperty(String string) {
        return knownRDFProperties.contains(string);
    }

    private void putElementQname(String string, String string2, String string3, Location location) throws SAXException {
        Warn warn = null;
        if (string.equals(rdfns)) {
            Integer n = (Integer)rdfnames.get(string2);
            if (n == null) {
                if (this.isMemberProperty(string2)) {
                    this.pipe.putNextToken(new ARPQname(17, location, string, string2, string3));
                    return;
                }
                if (!knownRDFTypes.contains(string2) && !this.isKnownRDFProperty(string2)) {
                    warn = knownBadRDFNames.contains(string2) ? new Warn(205, location, "Creating statement(s) for syntactic RDF element: '<rdf:" + string2 + "'.") : new Warn(113, location, "Creating statement(s) for unknown RDF element: '<rdf:" + string2 + "'.");
                }
            } else {
                this.pipe.putNextToken(new ARPQname(n, location, string, string2, string3));
                return;
            }
        }
        this.pipe.putNextToken(new ARPQname(15, location, string, string2, string3));
        if (warn != null) {
            this.pipe.putNextToken(warn);
        }
    }

    private void putAttributeQname(String string, String string2, String string3, Location location) throws SAXException {
        if (string.equals(rdfns)) {
            if (this.isMemberProperty(string2)) {
                this.pipe.putNextToken(new ARPQname(13, location, string, string2, string3));
                return;
            }
            if (!this.isKnownRDFProperty(string2)) {
                if (knownBadRDFNames.contains(string2)) {
                    this.putWarning(206, location, "Inappropriate or removed RDF attribute: 'rdf:" + string2 + "'.");
                } else {
                    this.putWarning(103, location, "Creating statement for unknown RDF property: 'rdf:" + string2 + "'.");
                }
            }
        }
        this.pipe.putNextToken(new ARPQname(12, location, string, string2, string3));
    }

    public void endEntity(String string) {
    }

    public void endDTD() {
    }

    public void startDTD(String string, String string2, String string3) {
    }

    public void endCDATA() {
    }

    public void startCDATA() {
    }

    public void comment(char[] cArray, int n, int n2) {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(3, location, new String(cArray, n, n2)));
    }

    public void startEntity(String string) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(2, location, string2 == null ? string : string + " " + string2));
    }

    public void error(SAXParseException sAXParseException) {
        this.saxError(209, sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        this.saxError(126, sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.saxError(301, sAXParseException);
        throw new DontDieYetException();
    }

    private void generalError(int n, Exception exception) {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new ExceptionToken(n, location, exception));
    }

    private void saxError(int n, SAXParseException sAXParseException) {
        Location location = new Location(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        this.pipe.putNextToken(new ExceptionToken(n, location, sAXParseException));
    }

    public void endLocalScope(Object object) {
        if (this.scopeHandler != nullScopeHandler && object != null && object instanceof ARPResource) {
            ARPResource aRPResource = (ARPResource)object;
            if (!aRPResource.isAnonymous()) {
                return;
            }
            if (!aRPResource.getHasBeenUsed()) {
                return;
            }
            if (aRPResource.hasNodeID()) {
                if (this.scopeHandler.discardNodesWithNodeID()) {
                    return;
                }
                String string = aRPResource.nodeID;
                if (!this.nodeIdUserData.containsKey(string)) {
                    this.nodeIdUserData.put(string, null);
                }
            } else {
                this.scopeHandler.endBNodeScope(aRPResource);
            }
        }
    }

    public void endRDF() {
        this.scopeHandler.endRDF();
    }

    public void startRDF() {
        this.scopeHandler.startRDF();
    }

    public boolean ignoring(int n) {
        return this.errorMode[n] == 0;
    }

    static {
        CharacterModel.isFullyNormalizedConstruct("make the linkage error happen early");
        ARP.initEncoding();
        nullScopeHandler = new ExtendedHandler(){

            public void endBNodeScope(AResource aResource) {
            }

            public void startRDF() {
            }

            public void endRDF() {
            }

            public boolean discardNodesWithNodeID() {
                return true;
            }
        };
        rdfns = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".intern();
        xmlns = "http://www.w3.org/XML/1998/namespace".intern();
        rdfnames = new HashMap();
        rdfnames.put("Description", new Integer(7));
        rdfnames.put("RDF", new Integer(5));
        rdfnames.put("li", new Integer(16));
        knownRDFProperties = new HashSet();
        knownRDFTypes = knownRDFProperties;
        knownRDFTypes.add("Bag");
        knownRDFTypes.add("Seq");
        knownRDFTypes.add("Alt");
        knownRDFTypes.add("List");
        knownRDFTypes.add("XMLLiteral");
        knownRDFTypes.add("Property");
        knownRDFProperties.add("type");
        knownRDFTypes.add("Statement");
        knownRDFProperties.add("subject");
        knownRDFProperties.add("predicate");
        knownRDFProperties.add("object");
        knownRDFProperties.add("value");
        knownRDFProperties.add("first");
        knownRDFProperties.add("rest");
        knownRDFProperties.add("nil");
        knownBadRDFNames = new HashSet();
        knownBadRDFNames.add("ID");
        knownBadRDFNames.add("about");
        knownBadRDFNames.add("aboutEach");
        knownBadRDFNames.add("aboutEachPrefix");
        knownBadRDFNames.add("resource");
        knownBadRDFNames.add("bagID");
        knownBadRDFNames.add("parseType");
        knownBadRDFNames.add("datatype");
        knownBadRDFNames.add("li");
        knownBadRDFNames.add("type");
        knownBadRDFNames.add("Description");
        knownBadRDFNames.add("nodeID");
        specialAtts = new String[]{"base", "lang", "space", "ID", "about", "nodeID", "resource", "parseType", "datatype", "type"};
        specialNameSpaces = new String[]{xmlns, xmlns, xmlns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns};
        specialAttValues = new int[]{27, 28, 25, 8, 9, 10, 23, 18, 24, 14};
        defaultErrorMode = new int[400];
        for (int i = 0; i < defaultErrorMode.length; ++i) {
            ARPFilter.defaultErrorMode[i] = i / 100;
        }
    }

    private static class DontDieYetException
    extends RuntimeException {
        private DontDieYetException() {
        }
    }

    private static class MySAXParser
    extends SAXParser {
        ARPFilter a;

        MySAXParser(StandardParserConfiguration standardParserConfiguration) {
            super((XMLParserConfiguration)standardParserConfiguration);
            try {
                this.setFeature("http://xml.org/sax/features/string-interning", false);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) {
            this.a.setEncoding(string2 == null ? "UTF" : string2);
            super.xmlDecl(string, string2, string3, augmentations);
        }
    }
}

