/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.ontology.tidy.impl.AbsLookup;
import com.hp.hpl.jena.ontology.tidy.impl.CategorySet;
import com.hp.hpl.jena.ontology.tidy.impl.Grammar;
import com.hp.hpl.jena.ontology.tidy.impl.Lookup;
import com.hp.hpl.jena.ontology.tidy.impl.LookupLimits;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;

public class LookupTable
extends AbsLookup
implements LookupLimits,
Serializable {
    static final long serialVersionUID = -6759062485496972733L;
    private final byte[][] propertiesUsedWithObject;
    private final int[][][] keysByObjectAndPropertyIndex;
    private final byte[] propId;
    private final int[][] refinedSubject;
    private final int[][] refinedProperty;
    private final int[][] refinedObject;
    private static Lookup theInstance;
    private static final String DATAFILE = "etc/owl-syntax.ser";

    public LookupTable(byte[] byArray, byte[][] byArray2, int[][][] nArray, int[][] nArray2, int[][] nArray3, int[][] nArray4) {
        this.propId = byArray;
        this.propertiesUsedWithObject = byArray2;
        this.keysByObjectAndPropertyIndex = nArray;
        this.refinedSubject = nArray2;
        this.refinedProperty = nArray3;
        this.refinedObject = nArray4;
    }

    public void done(int n) {
    }

    public int qrefine(int n, int n2, int n4) {
        byte[] byArray = this.propertiesUsedWithObject[n4];
        byte by = this.propId[n2];
        if (byArray == null) {
            return -1;
        }
        int n5 = Arrays.binarySearch(byArray, by);
        if (n5 < 0) {
            return -1;
        }
        int[] nArray = this.keysByObjectAndPropertyIndex[n4][n5];
        int n6 = n << 22;
        int n7 = Arrays.binarySearch(nArray, n6);
        if (n7 >= 0) {
            throw new BrokenException("LookupTable malformed - value: " + n6);
        }
        if ((n7 = -n7 - 1) == nArray.length) {
            return -1;
        }
        if ((nArray[n7] & 0x7FC00000) == n6) {
            return nArray[n7];
        }
        return -1;
    }

    public int subject(int n, int n2) {
        if (n != n2 >>> 22) {
            throw new IllegalArgumentException("Internal error in OWL Syntax Checker");
        }
        return this.refinedSubject[n][(n2 & 0x3F0000) >> 16];
    }

    public int prop(int n, int n2) {
        return this.refinedProperty[n][(n2 & 0xE000) >> 13];
    }

    public int object(int n, int n2) {
        return this.refinedObject[n][(n2 & 0x1F00) >> 8];
    }

    public byte allActions(int n) {
        return (byte)((n & 0xFF) >> 0);
    }

    static final int[] intersection(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (Arrays.binarySearch(nArray2, nArray[i]) < 0) continue;
            nArray3[n++] = nArray[i];
        }
        int[] nArray4 = new int[n];
        System.arraycopy(nArray3, 0, nArray4, 0, n);
        return nArray4;
    }

    public int meet(int n, int n2) {
        int[] nArray;
        int[] nArray2 = CategorySet.getSet(n);
        int n4 = CategorySet.find(LookupTable.intersection(nArray2, nArray = CategorySet.getSet(n2)), true);
        return Grammar.isPseudoCategory(n4) ? -1 : n4;
    }

    private static Lookup restore() {
        Lookup lookup;
        try {
            InputStream inputStream = FileUtils.openResourceFileAsStream(DATAFILE);
            if (inputStream == null) {
                throw new BrokenException("Failed to find compiled table.");
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            lookup = (Lookup)objectInputStream.readObject();
            Vector vector = (Vector)objectInputStream.readObject();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ((CategorySet)iterator.next()).restore();
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new BrokenException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BrokenException(classNotFoundException);
        }
        CategorySet.closed = true;
        return lookup;
    }

    public void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(DATAFILE);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.writeObject(CategorySet.unsorted);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new BrokenException(iOException);
        }
    }

    public static Lookup get() {
        if (theInstance == null) {
            theInstance = LookupTable.restore();
        }
        return theInstance;
    }

    boolean canBeSubj(int n) {
        return this.refinedSubject[n] != null && this.refinedSubject[n].length > 0;
    }

    boolean canBeProp(int n) {
        return this.refinedProperty[n] != null && this.refinedProperty[n].length > 0;
    }
}

