/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class OntTestBase
extends TestSuite {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";

    public OntTestBase(String string) {
        super(string);
        OntTestCase[] ontTestCaseArray = this.getTests();
        for (int i = 0; i < ontTestCaseArray.length; ++i) {
            this.addTest((Test)ontTestCaseArray[i]);
        }
    }

    protected OntTestCase[] getTests() {
        return null;
    }

    protected abstract class OntTestCase
    extends TestCase {
        protected boolean m_inOWL;
        protected boolean m_inOWLLite;
        protected boolean m_inDAML;
        protected boolean m_inRDFS;
        protected String m_langElement;
        protected boolean m_owlLang = true;
        protected boolean m_owlLiteLang = false;
        protected boolean m_rdfsLang = false;
        protected boolean m_damlLang = false;

        public OntTestCase(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super("Ontology API test " + string);
            this.m_langElement = string;
            this.m_inOWL = bl;
            this.m_inOWLLite = bl2;
            this.m_inDAML = bl3;
            this.m_inRDFS = bl4;
        }

        public void runTest() throws Exception {
            this.runTest(ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null), this.m_inOWL);
            this.m_owlLiteLang = true;
            this.runTest(ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM, null), this.m_inOWLLite);
            this.m_owlLang = false;
            this.m_owlLiteLang = false;
            this.m_damlLang = true;
            this.runTest(ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null), this.m_inDAML);
            this.m_rdfsLang = true;
            this.m_damlLang = false;
            this.runTest(ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM, null), this.m_inRDFS);
        }

        protected void runTest(OntModel ontModel, boolean bl) throws Exception {
            boolean bl2 = false;
            try {
                this.ontTest(ontModel);
            }
            catch (ProfileException profileException) {
                bl2 = true;
            }
            OntTestCase.assertEquals((String)("language element " + this.m_langElement + " was " + (bl ? "" : "not") + " expected in model " + ontModel.getProfile().getLabel()), (boolean)bl, (!bl2 ? 1 : 0) != 0);
        }

        protected abstract void ontTest(OntModel var1) throws Exception;

        protected void iteratorTest(Iterator iterator, Object[] objectArray) {
            TestUtil.assertIteratorValues(this, iterator, objectArray);
        }

        public void setUp() {
            OntDocumentManager.getInstance().reset(true);
        }
    }
}

