/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.PatternStage;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryPlan;
import com.hp.hpl.jena.graph.query.SimpleTreeQueryPlan;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashSet;

public class SimpleQueryHandler
implements QueryHandler {
    protected Graph graph;

    public SimpleQueryHandler(Graph graph) {
        this.graph = graph;
    }

    public Stage patternStage(Mapping mapping, ExpressionSet expressionSet, Triple[] tripleArray) {
        return new PatternStage(this.graph, mapping, expressionSet, tripleArray);
    }

    public BindingQueryPlan prepareBindings(Query query, Node[] nodeArray) {
        return new SimpleQueryPlan(this.graph, query, nodeArray);
    }

    public TreeQueryPlan prepareTree(Graph graph) {
        return new SimpleTreeQueryPlan(this.graph, graph);
    }

    public ExtendedIterator objectsFor(Node node, Node node2) {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = this.graph.find(node, node2, null);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getObject());
        }
        return WrappedIterator.create(hashSet.iterator());
    }

    public ExtendedIterator subjectsFor(Node node, Node node2) {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = this.graph.find(null, node, node2);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getSubject());
        }
        return WrappedIterator.create(hashSet.iterator());
    }

    public boolean containsNode(Node node) {
        return this.graph.contains(node, Node.ANY, Node.ANY) || this.graph.contains(Node.ANY, node, Node.ANY) || this.graph.contains(Node.ANY, Node.ANY, node);
    }
}

