/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphMatcher;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public abstract class GraphBase
implements Graph {
    protected final ReificationStyle style;
    protected boolean closed = false;
    protected GraphEventManager gem;
    private BulkUpdateHandler bud;
    protected Capabilities capabilities = null;
    private PrefixMapping pm = new PrefixMappingImpl();
    protected Reifier reifier = null;

    public GraphBase(ReificationStyle reificationStyle) {
        this.style = reificationStyle;
    }

    public GraphBase() {
        this(ReificationStyle.Minimal);
    }

    protected void checkOpen() {
        if (this.closed) {
            throw new ClosedException("already closed", this);
        }
    }

    public void close() {
        this.closed = true;
    }

    public boolean dependsOn(Graph graph) {
        return this == graph;
    }

    public QueryHandler queryHandler() {
        return new SimpleQueryHandler(this);
    }

    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager(this);
        }
        return this.gem;
    }

    public void notifyAdd(Triple triple) {
        this.getEventManager().notifyAddTriple(triple);
    }

    public void notifyDelete(Triple triple) {
        this.getEventManager().notifyDeleteTriple(triple);
    }

    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bud == null) {
            this.bud = new SimpleBulkUpdateHandler(this);
        }
        return this.bud;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities();
        }
        return this.capabilities;
    }

    public PrefixMapping getPrefixMapping() {
        return this.pm;
    }

    public void add(Triple triple) {
        this.checkOpen();
        this.performAdd(triple);
        this.notifyAdd(triple);
    }

    public void performAdd(Triple triple) {
        throw new AddDeniedException("GraphBase::performAdd");
    }

    public void delete(Triple triple) {
        this.checkOpen();
        this.performDelete(triple);
        this.notifyDelete(triple);
    }

    public void performDelete(Triple triple) {
        throw new DeleteDeniedException("GraphBase::delete");
    }

    public abstract ExtendedIterator find(TripleMatch var1);

    public boolean contains(Triple triple) {
        this.checkOpen();
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean contains(Node node, Node node2, Node node3) {
        this.checkOpen();
        return this.containsByFind(Triple.create(node, node2, node3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean containsByFind(Triple triple) {
        ExtendedIterator extendedIterator = this.find(triple);
        try {
            boolean bl = extendedIterator.hasNext();
            return bl;
        }
        finally {
            extendedIterator.close();
        }
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        this.checkOpen();
        return this.find(Triple.createMatch(node, node2, node3));
    }

    public Reifier getReifier() {
        if (this.reifier == null) {
            this.reifier = new SimpleReifier(this, this.style);
        }
        return this.reifier;
    }

    public int size() {
        this.checkOpen();
        ExtendedIterator extendedIterator = GraphUtil.findAll(this);
        int n = 0;
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isIsomorphicWith(Graph graph) {
        this.checkOpen();
        return graph != null && GraphMatcher.equals(this, graph);
    }

    public String toString() {
        return GraphBase.toString(this.closed ? "closed " : "", this);
    }

    public static String toString(String string, Graph graph) {
        PrefixMapping prefixMapping = graph.getPrefixMapping();
        StringBuffer stringBuffer = new StringBuffer(string + " {");
        String string2 = "";
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            stringBuffer.append(string2);
            string2 = "; ";
            stringBuffer.append(((Triple)extendedIterator.next()).toString(prefixMapping));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

