/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetIterator
implements ExtendedIterator {
    protected ResultSet m_resultSet;
    protected SQLCache m_sqlCache;
    protected PreparedStatement m_statement;
    protected String m_opname;
    protected ArrayList m_row;
    protected int m_nCols;
    protected boolean m_finished = false;
    protected boolean m_prefetched = false;
    protected static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$db$impl$ResultSetIterator == null ? (class$com$hp$hpl$jena$db$impl$ResultSetIterator = ResultSetIterator.class$("com.hp.hpl.jena.db.impl.ResultSetIterator")) : class$com$hp$hpl$jena$db$impl$ResultSetIterator));
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$ResultSetIterator;

    public ResultSetIterator() {
        this.m_finished = true;
    }

    public ResultSetIterator(ResultSet resultSet, PreparedStatement preparedStatement, SQLCache sQLCache, String string) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = sQLCache;
        this.m_statement = preparedStatement;
        this.m_opname = string;
    }

    public ResultSetIterator(ResultSet resultSet, PreparedStatement preparedStatement) {
        this.m_resultSet = resultSet;
        this.m_statement = preparedStatement;
    }

    public void reset(ResultSet resultSet, PreparedStatement preparedStatement, SQLCache sQLCache, String string) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = sQLCache;
        this.m_statement = preparedStatement;
        this.m_opname = string;
        this.m_finished = false;
        this.m_prefetched = false;
        this.m_row = null;
    }

    public boolean hasNext() {
        if (!this.m_finished && !this.m_prefetched) {
            this.moveForward();
        }
        return !this.m_finished;
    }

    public Object removeNext() {
        this.cantRemove();
        return null;
    }

    public Object next() {
        if (!this.m_finished && !this.m_prefetched) {
            this.moveForward();
        }
        this.m_prefetched = false;
        if (this.m_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        this.cantRemove();
    }

    protected void cantRemove() {
        throw new UnsupportedOperationException("ResultSetIterator can't remove database rows");
    }

    protected void moveForward() {
        try {
            if (!this.m_finished && this.m_resultSet.next()) {
                this.extractRow();
                this.m_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Problem in iterator over db result set, op = " + this.m_opname), (Throwable)exception);
            throw new JenaException(exception);
        }
    }

    protected void extractRow() throws Exception {
        int n;
        if (this.m_row == null) {
            this.m_nCols = this.m_resultSet.getMetaData().getColumnCount();
            this.m_row = new ArrayList(this.m_nCols);
            for (n = 0; n < this.m_nCols; ++n) {
                this.m_row.add(null);
            }
        }
        for (n = 0; n < this.m_nCols; ++n) {
            this.m_row.set(n, this.m_resultSet.getObject(n + 1));
        }
    }

    protected Object getRow() {
        return this.m_row;
    }

    public void close() {
        if (!this.m_finished) {
            if (this.m_resultSet != null) {
                try {
                    this.m_resultSet.close();
                    this.m_resultSet = null;
                }
                catch (SQLException sQLException) {
                    logger.warn((Object)"Error while finalizing result set iterator", (Throwable)sQLException);
                }
            }
            if (this.m_sqlCache != null && this.m_opname != null) {
                this.m_sqlCache.returnPreparedSQLStatement(this.m_statement, this.m_opname);
            } else {
                try {
                    this.m_statement.close();
                }
                catch (SQLException sQLException) {
                    logger.warn((Object)"Error while finalizing result set iterator", (Throwable)sQLException);
                }
            }
        }
        this.m_finished = true;
    }

    public Object getSingleton() throws SQLException {
        List list = (List)this.next();
        this.close();
        return list.get(0);
    }

    protected void finalize() throws SQLException {
        if (!this.m_finished && this.m_resultSet != null) {
            this.close();
        }
    }

    public ExtendedIterator andThen(ClosableIterator closableIterator) {
        return NiceIterator.andThen(this, closableIterator);
    }

    public ExtendedIterator filterKeep(Filter filter) {
        return new FilterIterator(filter, this);
    }

    public ExtendedIterator filterDrop(final Filter filter) {
        Filter filter2 = new Filter(){

            public boolean accept(Object object) {
                return !filter.accept(object);
            }
        };
        return new FilterIterator(filter2, this);
    }

    public ExtendedIterator mapWith(Map1 map1) {
        return new Map1Iterator(map1, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

