/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import java.util.List;

public interface IRDBDriver {
    public void setConnection(IDBConnection var1);

    public IDBConnection getConnection();

    public SpecializedGraph getSystemSpecializedGraph();

    public List createSpecializedGraphs(DBPropGraph var1);

    public List recreateSpecializedGraphs(DBPropGraph var1);

    public void removeSpecializedGraphs(DBPropGraph var1, List var2);

    public boolean isDBFormatOK();

    public void setDatabaseProperties(Graph var1);

    public DBPropGraph getDefaultModelProperties();

    public String getDatabaseType();

    public void cleanDB();

    public void close() throws RDFRDBException;

    public void formatDB() throws RDFRDBException;

    public String createTable(int var1, boolean var2);

    public void abort() throws RDFRDBException;

    public void begin() throws RDFRDBException;

    public void commit() throws RDFRDBException;

    public boolean transactionsSupported();

    public boolean supportsMultipleModels();

    public boolean supportsJenaReification();

    public int graphIdAlloc(String var1);

    public void graphIdDealloc(int var1);

    public int getInsertID(String var1);

    public String nodeToRDBString(Node var1, boolean var2);

    public Node RDBStringToNode(String var1);

    public String genSQLReifQualStmt();

    public String genSQLReifQualAnyObj(boolean var1);

    public String genSQLReifQualObj(char var1, boolean var2);

    public String genSQLQualConst(int var1, char var2, Node var3);

    public String genSQLReifQualConst(int var1, char var2, Node var3);

    public String genSQLQualParam(int var1, char var2);

    public String genSQLQualGraphId(int var1, int var2);

    public String genSQLJoin(int var1, char var2, int var3, char var4);

    public String genSQLResList(int[] var1, VarDesc[] var2);

    public String genSQLFromList(int var1, String var2);

    public String genSQLSelectStmt(String var1, String var2, String var3);

    public int getLongObjectLength();

    public void setLongObjectLength(int var1);

    public int getIndexKeyLength();

    public void setIndexKeyLength(int var1);

    public boolean getIsTransactionDb();

    public void setIsTransactionDb(boolean var1);

    public boolean getDoCompressURI();

    public void setDoCompressURI(boolean var1);

    public int getCompressURILength();

    public void setCompressURILength(int var1);

    public boolean getDoDuplicateCheck();

    public void setDoDuplicateCheck(boolean var1);

    public String getTableNamePrefix();

    public void setTableNamePrefix(String var1);

    public String getStoreWithModel();

    public void setStoreWithModel(String var1);

    public int getCompressCacheSize();

    public void setCompressCacheSize(int var1);

    public static class GenSQLAnd {
        private boolean init = false;

        GenSQLAnd() {
        }

        String gen(String string) {
            if (string == "") {
                return "";
            }
            if (!this.init) {
                this.init = true;
                return string;
            }
            return " AND " + string;
        }
    }
}

