/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;

public abstract class DBProp {
    protected SpecializedGraph graph = null;
    protected Node self = null;

    public DBProp(SpecializedGraph specializedGraph) {
        this.graph = specializedGraph;
        this.self = DBProp.generateNodeURI();
    }

    public DBProp(SpecializedGraph specializedGraph, Node node) {
        this.graph = specializedGraph;
        this.self = node;
    }

    public Node getNode() {
        return this.self;
    }

    protected static SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    protected void putPropString(Node_URI node_URI, String string) {
        this.putPropNode(node_URI, new Node_Literal(new LiteralLabel(string, "")));
    }

    protected void putPropNode(Node_URI node_URI, Node node) {
        this.graph.add(Triple.create(this.self, node_URI, node), DBProp.newComplete());
    }

    protected String getPropString(Node_URI node_URI) {
        ExtendedIterator extendedIterator = this.graph.find(this.self, node_URI, null, DBProp.newComplete());
        if (!extendedIterator.hasNext()) {
            extendedIterator.close();
            return null;
        }
        Node node = ((Triple)extendedIterator.next()).getObject();
        extendedIterator.close();
        return node.getLiteral().getLexicalForm();
    }

    protected void remove() {
        SpecializedGraph.CompletionFlag completionFlag = DBProp.newComplete();
        ExtendedIterator extendedIterator = this.graph.find(this.self, null, null, completionFlag);
        while (extendedIterator.hasNext()) {
            this.graph.delete((Triple)extendedIterator.next(), completionFlag);
        }
        extendedIterator.close();
        this.self = null;
        this.graph = null;
    }

    public static ExtendedIterator listTriples(SpecializedGraph specializedGraph, Node node) {
        return specializedGraph.find(node, null, null, DBProp.newComplete());
    }

    protected static Node findProperty(Graph graph, Node_URI node_URI) {
        ExtendedIterator extendedIterator = graph.find(null, node_URI, null);
        Node node = null;
        if (extendedIterator.hasNext()) {
            node = ((Triple)extendedIterator.next()).getObject();
        }
        extendedIterator.close();
        return node;
    }

    public static String generateUniqueID() {
        String string;
        UID uID = new UID();
        try {
            string = InetAddress.getLocalHost().getHostAddress().toString();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        return (string + uID.toString()).replace('.', '_').replace(':', '_').replace('-', '_');
    }

    public static Node_URI generateNodeURI() {
        Object var0 = null;
        return new Node_URI("http://jena.hpl.hp.com/2003/04/DB#" + DBProp.generateUniqueID());
    }
}

