/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.Free;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier_RDB;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Bound;
import com.hp.hpl.jena.graph.query.Element;
import com.hp.hpl.jena.graph.query.Fixed;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import java.util.ArrayList;
import java.util.List;

public class DBPattern {
    Triple pattern;
    Element S;
    Element P;
    Element O;
    int Scost;
    int Pcost;
    int Ocost;
    boolean isStaged;
    boolean isConnected;
    boolean isSingleSource;
    boolean isStmt;
    boolean isReif;
    List source;
    char subsumed;
    static final int costMax = 100;
    static final int costMin = 1;
    int costCur;
    private boolean costInit = true;
    private int freeVarCnt = 0;
    private int fixedCost = 0;
    private int boundCost = 0;
    private int unboundCost = 4;
    private int unboundPredFactor = 4;

    public DBPattern(Triple triple, Mapping mapping) {
        this.pattern = triple;
        this.source = new ArrayList();
        this.isStaged = false;
        this.isConnected = false;
        this.isSingleSource = false;
        this.isReif = false;
        this.isStmt = false;
        this.S = this.nodeToElement(this.pattern.getSubject(), mapping);
        this.P = this.nodeToElement(this.pattern.getPredicate(), mapping);
        this.O = this.nodeToElement(this.pattern.getObject(), mapping);
        this.Scost = this.elementCost(this.S);
        this.Pcost = this.elementCost(this.P);
        this.Ocost = this.elementCost(this.O);
    }

    private Element nodeToElement(Node node, Mapping mapping) {
        if (node.equals(Query.ANY)) {
            return Element.ANY;
        }
        if (node.isVariable()) {
            if (mapping.hasBound(node)) {
                return new Bound(mapping.indexOf(node));
            }
            ++this.freeVarCnt;
            return new Free(node);
        }
        return new Fixed(node);
    }

    public void sourceAdd(SpecializedGraph specializedGraph, char c) {
        if (this.source.isEmpty()) {
            this.subsumed = c;
            this.isSingleSource = true;
            if (specializedGraph instanceof SpecializedGraphReifier_RDB) {
                this.isReif = true;
            } else {
                this.isStmt = true;
            }
        } else {
            if (this.subsumed != c) {
                throw new RDFRDBException("Specialized graphs incorrectly subsume pattern");
            }
            this.isSingleSource = false;
            if (specializedGraph instanceof SpecializedGraphReifier_RDB) {
                this.isStmt = false;
            } else {
                this.isReif = false;
            }
        }
        this.source.add(specializedGraph);
    }

    public boolean hasSource() {
        return !this.source.isEmpty();
    }

    public boolean isSingleSource() {
        return this.isSingleSource;
    }

    public SpecializedGraph singleSource() {
        return (SpecializedGraph)this.source.get(0);
    }

    protected void addFreeVars(List list) {
        if (this.freeVarCnt > 0) {
            if (this.S instanceof Free) {
                this.addVar(list, (Free)this.S);
            }
            if (this.P instanceof Free) {
                this.addVar(list, (Free)this.P);
            }
            if (this.O instanceof Free) {
                this.addVar(list, (Free)this.O);
            }
        }
    }

    private int findVar(List list, Node_Variable node_Variable) {
        for (int i = 0; i < list.size(); ++i) {
            Node_Variable node_Variable2 = ((VarDesc)list.get((int)i)).var;
            if (!node_Variable.equals(node_Variable2)) continue;
            return i;
        }
        return -1;
    }

    private void addVar(List list, Free free) {
        int n = this.findVar(list, free.var());
        if (n < 0) {
            n = list.size();
            VarDesc varDesc = free.isArg() ? new VarDesc(free.var(), free.getMapping(), n) : new VarDesc(free.var(), n);
            list.add(varDesc);
        }
        free.setListing(n);
    }

    public boolean joinsWith(DBPattern dBPattern, List list, boolean bl, boolean bl2) {
        if (dBPattern.isSingleSource() && this.source.contains(dBPattern.source.get(0)) && (!(this.P instanceof Free) || bl && this.isStmt)) {
            if (this.S instanceof Free && this.findVar(list, ((Free)this.S).var()) >= 0) {
                return true;
            }
            if (this.O instanceof Free && this.findVar(list, ((Free)this.O).var()) >= 0) {
                return true;
            }
            if (bl && this.isStmt && this.P instanceof Free && this.findVar(list, ((Free)this.P).var()) >= 0) {
                return true;
            }
        }
        return false;
    }

    public int cost(Mapping mapping) {
        if (this.costInit) {
            this.costInit = false;
            this.costCur = this.costCalc();
        } else if (this.freeVarCnt > 0 && this.anyBound(mapping)) {
            this.costCur = this.costCalc();
        }
        return this.costCur;
    }

    protected boolean isArgCheck(Free free, Mapping mapping) {
        int n = mapping.lookUp(free.var());
        if (n >= 0) {
            free.setIsArg(n);
            this.isConnected = true;
            --this.freeVarCnt;
            return true;
        }
        return false;
    }

    protected boolean anyBound(Mapping mapping) {
        boolean bl = false;
        if (this.S instanceof Free && this.isArgCheck((Free)this.S, mapping)) {
            this.Scost = this.elementCost(this.S);
            bl = true;
        }
        if (this.P instanceof Free && this.isArgCheck((Free)this.P, mapping)) {
            this.Pcost = this.elementCost(this.P);
            bl = true;
        }
        if (this.O instanceof Free && this.isArgCheck((Free)this.O, mapping)) {
            this.Ocost = this.elementCost(this.O);
            bl = true;
        }
        return bl;
    }

    private int elementCost(Element element) {
        if (element instanceof Fixed) {
            return this.fixedCost;
        }
        if (element instanceof Bound) {
            return this.boundCost;
        }
        if (element instanceof Free && ((Free)element).isArg()) {
            return this.boundCost;
        }
        return this.unboundCost;
    }

    private int costCalc() {
        return this.Scost + this.Pcost + this.Ocost;
    }
}

