/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDBaseNumericType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDBaseStringType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDByteType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDDateTimeType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDDateType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDDayType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDDouble;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDDurationType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDFloat;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDGenericType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDMonthDayType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDMonthType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDTimeType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDYearMonthType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDYearType;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;
import org.apache.xerces.impl.dv.xs.DecimalDV;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;

public class XSDDatatype
extends BaseDatatype {
    public static final String XSD = "http://www.w3.org/2001/XMLSchema";
    public static final XSDDatatype XSDfloat = new XSDFloat("float", class$java$lang$Float == null ? (class$java$lang$Float = XSDDatatype.class$("java.lang.Float")) : class$java$lang$Float);
    public static final XSDDatatype XSDdouble = new XSDDouble("double", class$java$lang$Double == null ? (class$java$lang$Double = XSDDatatype.class$("java.lang.Double")) : class$java$lang$Double);
    public static final XSDDatatype XSDint = new XSDBaseNumericType("int", class$java$lang$Integer == null ? (class$java$lang$Integer = XSDDatatype.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final XSDDatatype XSDlong = new XSDBaseNumericType("long", class$java$lang$Long == null ? (class$java$lang$Long = XSDDatatype.class$("java.lang.Long")) : class$java$lang$Long);
    public static final XSDDatatype XSDshort = new XSDBaseNumericType("short", class$java$lang$Short == null ? (class$java$lang$Short = XSDDatatype.class$("java.lang.Short")) : class$java$lang$Short);
    public static final XSDDatatype XSDbyte = new XSDByteType("byte", class$java$lang$Byte == null ? (class$java$lang$Byte = XSDDatatype.class$("java.lang.Byte")) : class$java$lang$Byte);
    public static final XSDDatatype XSDunsignedByte = new XSDBaseNumericType("unsignedByte");
    public static final XSDDatatype XSDunsignedShort = new XSDBaseNumericType("unsignedShort");
    public static final XSDDatatype XSDunsignedInt = new XSDBaseNumericType("unsignedInt");
    public static final XSDDatatype XSDunsignedLong = new XSDBaseNumericType("unsignedLong");
    public static final XSDDatatype XSDdecimal = new XSDBaseNumericType("decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XSDDatatype.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    public static final XSDDatatype XSDinteger = new XSDBaseNumericType("integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = XSDDatatype.class$("java.math.BigInteger")) : class$java$math$BigInteger);
    public static final XSDDatatype XSDnonPositiveInteger = new XSDBaseNumericType("nonPositiveInteger");
    public static final XSDDatatype XSDnonNegativeInteger = new XSDBaseNumericType("nonNegativeInteger");
    public static final XSDDatatype XSDpositiveInteger = new XSDBaseNumericType("positiveInteger");
    public static final XSDDatatype XSDnegativeInteger = new XSDBaseNumericType("negativeInteger");
    public static final XSDDatatype XSDboolean = new XSDDatatype("boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = XSDDatatype.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static final XSDDatatype XSDstring = new XSDBaseStringType("string", class$java$lang$String == null ? (class$java$lang$String = XSDDatatype.class$("java.lang.String")) : class$java$lang$String);
    public static final XSDDatatype XSDnormalizedString = new XSDBaseStringType("normalizedString", class$java$lang$String == null ? (class$java$lang$String = XSDDatatype.class$("java.lang.String")) : class$java$lang$String);
    public static final XSDDatatype XSDanyURI = new XSDDatatype("anyURI");
    public static final XSDDatatype XSDtoken = new XSDBaseStringType("token");
    public static final XSDDatatype XSDName = new XSDBaseStringType("Name");
    public static final XSDDatatype XSDQName = new XSDDatatype("QName");
    public static final XSDDatatype XSDlanguage = new XSDBaseStringType("language");
    public static final XSDDatatype XSDNMTOKEN = new XSDBaseStringType("NMTOKEN");
    public static final XSDDatatype XSDENTITY = new XSDBaseStringType("ENTITY");
    public static final XSDDatatype XSDID = new XSDBaseStringType("ID");
    public static final XSDDatatype XSDNCName = new XSDBaseStringType("NCName");
    public static final XSDDatatype XSDIDREF = new XSDDatatype("IDREF");
    public static final XSDDatatype XSDNOTATION = new XSDDatatype("NOTATION");
    public static final XSDDatatype XSDhexBinary = new XSDDatatype("hexBinary");
    public static final XSDDatatype XSDbase64Binary = new XSDDatatype("base64Binary");
    public static final XSDDatatype XSDdate = new XSDDateType("date");
    public static final XSDDatatype XSDtime = new XSDTimeType("time");
    public static final XSDDatatype XSDdateTime = new XSDDateTimeType("dateTime");
    public static final XSDDatatype XSDduration = new XSDDurationType();
    public static final XSDDatatype XSDgDay = new XSDDayType("gDay");
    public static final XSDDatatype XSDgMonth = new XSDMonthType("gMonth");
    public static final XSDDatatype XSDgYear = new XSDYearType("gYear");
    public static final XSDDatatype XSDgYearMonth = new XSDYearMonthType("gYearMonth");
    public static final XSDDatatype XSDgMonthDay = new XSDMonthDayType("gMonthDay");
    protected XSSimpleType typeDeclaration;
    protected Class javaClass = null;
    static final DecimalDV decimalDV = new DecimalDV();
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public XSDDatatype(String string) {
        super("");
        this.typeDeclaration = SchemaDVFactory.getInstance().getBuiltInType(string);
        this.uri = this.typeDeclaration.getNamespace() + "#" + this.typeDeclaration.getName();
    }

    public XSDDatatype(String string, Class clazz) {
        this(string);
        this.javaClass = clazz;
    }

    public XSDDatatype(XSSimpleType xSSimpleType, String string) {
        super("");
        this.typeDeclaration = xSSimpleType;
        this.uri = string + "#" + this.typeDeclaration.getName();
    }

    public Object parse(String string) throws DatatypeFormatException {
        try {
            ValidationState validationState = new ValidationState();
            ValidatedInfo validatedInfo = new ValidatedInfo();
            Object object = this.typeDeclaration.validate(string, (ValidationContext)validationState, validatedInfo);
            return this.convertValidatedDataValue(validatedInfo);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DatatypeFormatException(string, this, "during parse -" + (Object)((Object)invalidDatatypeValueException));
        }
    }

    public String unparse(Object object) {
        return object.toString();
    }

    public boolean isEqual(LiteralLabel literalLabel, LiteralLabel literalLabel2) {
        return this.typeDeclaration.isEqual(literalLabel.getValue(), literalLabel2.getValue());
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public Object extendedTypeDefinition() {
        return this.typeDeclaration;
    }

    public static List loadUserDefined(String string, Reader reader, String string2, TypeMapper typeMapper) throws DatatypeFormatException {
        return XSDDatatype.loadUserDefined(new XMLInputSource(null, string, string, reader, string2), typeMapper);
    }

    public static List loadUserDefined(String string, String string2, TypeMapper typeMapper) throws DatatypeFormatException {
        return XSDDatatype.loadUserDefined(new XMLInputSource(null, string, string), typeMapper);
    }

    private static List loadUserDefined(XMLInputSource xMLInputSource, TypeMapper typeMapper) throws DatatypeFormatException {
        XMLGrammarPreparser xMLGrammarPreparser = new XMLGrammarPreparser();
        xMLGrammarPreparser.registerPreparser(XSD, null);
        try {
            XSGrammar xSGrammar = (XSGrammar)xMLGrammarPreparser.preparseGrammar(XSD, xMLInputSource);
            XSModel xSModel = xSGrammar.toXSModel();
            XSNamedMap xSNamedMap = xSModel.getComponents((short)16);
            int n = xSNamedMap.getLength();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                XSSimpleType xSSimpleType = (XSSimpleType)xSNamedMap.item(i);
                if (XSD.equals(xSSimpleType.getNamespace())) continue;
                XSDGenericType xSDGenericType = new XSDGenericType(xSSimpleType, xMLInputSource.getSystemId());
                typeMapper.registerDatatype(xSDGenericType);
                arrayList.add(xSDGenericType.getURI());
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DatatypeFormatException(exception.toString());
        }
    }

    public Object convertValidatedDataValue(ValidatedInfo validatedInfo) throws DatatypeFormatException {
        switch (validatedInfo.actualValueType) {
            case 17: {
                byte[] byArray = Base64.decode((String)validatedInfo.normalizedValue);
                return new String(byArray);
            }
            case 3: {
                return (Boolean)validatedInfo.actualValue;
            }
            case 16: {
                byte[] byArray = HexBin.decode((String)validatedInfo.normalizedValue);
                return new String(byArray);
            }
            case 34: 
            case 40: {
                return Integer.valueOf(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
            }
            case 33: 
            case 39: {
                return Long.valueOf(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
            }
            case 35: 
            case 41: {
                return Short.valueOf(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
            }
            case 36: {
                return Byte.valueOf(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
            }
            case 4: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                Object object = validatedInfo.actualValue;
                if (decimalDV.getTotalDigits(object) == 0) {
                    return new Long(0L);
                }
                if (decimalDV.getFractionDigits(object) >= 1) {
                    return new BigDecimal(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
                }
                String string = XSDDatatype.trimPlus(validatedInfo.normalizedValue);
                int n = string.indexOf(46);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if (decimalDV.getTotalDigits(object) > 18) {
                    return new BigInteger(string);
                }
                return new Long(string);
            }
        }
        return this.parseValidated(validatedInfo.normalizedValue);
    }

    public Object parseValidated(String string) {
        return string;
    }

    public static String trimPlus(String string) {
        int n = string.indexOf(43);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static void loadXSDSimpleTypes(TypeMapper typeMapper) {
        typeMapper.registerDatatype(new XSDDatatype("anySimpleType"));
        typeMapper.registerDatatype(XSDdecimal);
        typeMapper.registerDatatype(XSDinteger);
        typeMapper.registerDatatype(XSDnonPositiveInteger);
        typeMapper.registerDatatype(XSDnonNegativeInteger);
        typeMapper.registerDatatype(XSDpositiveInteger);
        typeMapper.registerDatatype(XSDnegativeInteger);
        typeMapper.registerDatatype(XSDbyte);
        typeMapper.registerDatatype(XSDunsignedByte);
        typeMapper.registerDatatype(XSDdouble);
        typeMapper.registerDatatype(XSDfloat);
        typeMapper.registerDatatype(XSDlong);
        typeMapper.registerDatatype(XSDunsignedInt);
        typeMapper.registerDatatype(XSDunsignedShort);
        typeMapper.registerDatatype(XSDunsignedLong);
        typeMapper.registerDatatype(XSDint);
        typeMapper.registerDatatype(XSDshort);
        typeMapper.registerDatatype(XSDboolean);
        typeMapper.registerDatatype(XSDbase64Binary);
        typeMapper.registerDatatype(XSDhexBinary);
        typeMapper.registerDatatype(XSDdate);
        typeMapper.registerDatatype(XSDtime);
        typeMapper.registerDatatype(XSDdateTime);
        typeMapper.registerDatatype(XSDduration);
        typeMapper.registerDatatype(XSDgYearMonth);
        typeMapper.registerDatatype(XSDgMonthDay);
        typeMapper.registerDatatype(XSDgMonth);
        typeMapper.registerDatatype(XSDgDay);
        typeMapper.registerDatatype(XSDgYear);
        typeMapper.registerDatatype(XSDnormalizedString);
        typeMapper.registerDatatype(XSDstring);
        typeMapper.registerDatatype(XSDanyURI);
        typeMapper.registerDatatype(XSDtoken);
        typeMapper.registerDatatype(XSDName);
        typeMapper.registerDatatype(XSDlanguage);
        typeMapper.registerDatatype(XSDQName);
        typeMapper.registerDatatype(XSDNMTOKEN);
        typeMapper.registerDatatype(XSDID);
        typeMapper.registerDatatype(XSDENTITY);
        typeMapper.registerDatatype(XSDNCName);
        typeMapper.registerDatatype(XSDNOTATION);
        typeMapper.registerDatatype(XSDIDREF);
    }

    public static void main(String[] stringArray) {
        SymbolHash symbolHash = SchemaDVFactory.getInstance().getBuiltInTypes();
        int n = symbolHash.getLength();
        Object[] objectArray = new Object[n];
        symbolHash.getValues(objectArray, 0);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof XSSimpleTypeDecl) {
                XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)objectArray[i];
                System.out.println("tm.registerDatatype(new XSDDatatype(\"" + xSSimpleTypeDecl.getName() + "\"));");
                continue;
            }
            System.out.println(" - " + objectArray[i]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

