/*
 * Decompiled with CFR 0.152.
 */
package ca.icapture.moby.verifier;

import ca.icapture.moby.util.Constants;
import ca.icapture.moby.util.Log;
import ca.icapture.moby.verifier.Communicator;
import ca.icapture.moby.verifier.DataMngr;
import ca.icapture.moby.vocabulary.MP;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DC_11;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Enumeration;
import java.util.Hashtable;

public class ServiceDescrParser {
    Model servDescrMd;
    int in = 0;
    int out = 0;
    int bag = 0;
    int[] ver = new int[8];
    int n = 0;

    ServiceDescrParser(Model serviceDescrMd) {
        this.servDescrMd = serviceDescrMd;
    }

    public void getValidRDF(String servName, String authURI, String rdfAddr) {
        int amount = 0;
        int validMoby = 0;
        int servFound = 0;
        ResIterator iter = this.servDescrMd.listSubjectsWithProperty(DC_11.title);
        while (iter.hasNext()) {
            String resource = iter.next().toString();
            Hashtable servSign = new Hashtable();
            ++amount;
            servSign = this.getServSignature(resource);
            boolean a = servSign.isEmpty();
            if (a) continue;
            ++validMoby;
            Hashtable servInp = new Hashtable();
            servInp = this.getInput(resource);
            Hashtable servOut = new Hashtable();
            servOut = this.getOutput(resource);
            int i = 0;
            while (i < this.ver.length) {
                this.ver[i] = 0;
                ++i;
            }
            int upd = DataMngr.updService(servSign, servInp, servOut, servName, authURI, rdfAddr);
            servFound += upd;
        }
        if (servFound <= 0) {
            String msg = "SERVICE ****< " + servName + "," + authURI + " >**** IS NOT FOUND ON THE SERVER.IT WILL BE DELETED FROM THE MOBYCENTRAL REGISTRY";
            Log.warning(msg);
            if (Constants.MB_MAIL_SERVER != null) {
                String to = DataMngr.getContactEmail(servName);
                Communicator.sendMail(to, Constants.SP_SUBJECT, msg, Constants.MB_FROM);
            }
            DataMngr.delService(servName, authURI);
        }
        Log.info("Number of services = " + amount);
        Log.info("Number of ValidMoby services = " + validMoby);
        Log.info("=======================================================================");
    }

    public Hashtable getServSignature(String resource) {
        Hashtable<String, String> sign = new Hashtable<String, String>();
        Resource si = this.servDescrMd.getResource(resource);
        ++this.n;
        Log.info("RDF " + this.n + " : " + si);
        StmtIterator signNum = si.listProperties();
        while (signNum.hasNext()) {
            Statement stmtSign = signNum.nextStatement();
            String signPred = stmtSign.getPredicate().toString().trim();
            String signNode = stmtSign.getObject().toString();
            String[] rezNode = signNode.split(":http:");
            signNode = rezNode[0];
            String[] result = signPred.split("#");
            int i = result.length - 1;
            if (i == 0) {
                String[] res = signPred.split("/");
                int j = res.length - 1;
                String name = this.getFieldName(res[j]);
                sign.put(name, signNode);
                continue;
            }
            if (result[i].equals("input") | result[i].equals("consumes")) {
                this.in = 1;
            }
            if (result[i].equals("output") | result[i].equals("produces")) {
                this.out = 1;
            }
            String name = this.getFieldName(result[i]);
            sign.put(name, signNode);
        }
        int vn = 0;
        while (vn < this.ver.length) {
            if (this.ver[vn] != 1) {
                Log.info("THE RDF IS NOT VALID MOBY RDF - absent " + this.ver[vn]);
                sign.clear();
                break;
            }
            if (this.in == 0 && this.out == 0) {
                Log.info("THE RDF IS NOT VALID MOBY RDF - Consumes and Produces absent");
                sign.clear();
            } else {
                Enumeration enumeration = sign.keys();
            }
            ++vn;
        }
        return sign;
    }

    public Hashtable getInput(String resource) {
        boolean bagin = false;
        int sin = 1;
        int cin = 1;
        int sec = 1;
        Hashtable input = new Hashtable();
        Resource si = this.servDescrMd.getResource(resource);
        NodeIterator ob2iter = this.servDescrMd.listObjectsOfProperty(si, MP.consumes);
        while (ob2iter.hasNext()) {
            StmtIterator p23iter = ((Resource)ob2iter.next()).listProperties();
            while (p23iter.hasNext()) {
                Enumeration num;
                String l4Nodestr;
                String[] rezNode1;
                String name;
                int i;
                String[] result;
                String l4Node1;
                String l4Pred1;
                Statement l4iter;
                StmtIterator p34iter;
                Resource l3Res;
                Hashtable<String, String> siminp = new Hashtable<String, String>();
                Hashtable<String, String> colinp = new Hashtable<String, String>();
                Hashtable<String, String> secinp = new Hashtable<String, String>();
                StringBuffer sumsns = new StringBuffer();
                StringBuffer sumen = new StringBuffer();
                Statement l3iter = p23iter.nextStatement();
                Property l3Pred = l3iter.getPredicate();
                Node l3Node = l3iter.getObject().asNode();
                if (l3Pred.equals((Object)RDF.type)) {
                    bagin = true;
                    continue;
                }
                if (l3Pred.equals((Object)MP.SimpleArticle)) {
                    l3Res = l3iter.getResource();
                    p34iter = l3Res.listProperties();
                    while (p34iter.hasNext()) {
                        l4iter = p34iter.nextStatement();
                        l4Pred1 = l4iter.getPredicate().toString();
                        l4Node1 = l4iter.getObject().toString();
                        result = l4Pred1.split("#");
                        i = result.length - 1;
                        name = this.getInpOutName(result[i]);
                        rezNode1 = l4iter.getObject().toString().split(":http:");
                        l4Nodestr = rezNode1[0];
                        if (name.equals("namespace_type_uris")) {
                            siminp.remove("namespace_type_uris");
                            sumsns.append(String.valueOf(l4Nodestr) + ",");
                            siminp.put(name, sumsns.toString());
                            continue;
                        }
                        siminp.put(name, l4Nodestr);
                    }
                    if (siminp.isEmpty()) continue;
                    input.put("siminp" + sin, siminp);
                    num = siminp.keys();
                    Log.info("Simple input " + (++sin - 1));
                    continue;
                }
                if (l3Pred.equals((Object)MP.CollectionArticle)) {
                    l3Res = l3iter.getResource();
                    if (l3Res.hasProperty(RDF.type, (RDFNode)RDF.Bag) && l3Res.hasProperty(RDF.li((int)1))) {
                        p34iter = l3Res.listProperties();
                        if (l3Res.hasProperty(MP.article_name)) {
                            String col_artName = l3Res.getProperty(MP.article_name).getObject().toString();
                            String[] rezNode = col_artName.split(":http:");
                            col_artName = rezNode[0];
                            colinp.put("col_articleName", col_artName);
                        }
                        while (p34iter.hasNext()) {
                            Resource l4Res;
                            StmtIterator p45iter;
                            l4iter = p34iter.nextStatement();
                            Property l4Pred = l4iter.getPredicate();
                            Node l4Node = l4iter.getObject().asNode();
                            if (!l4Node.isBlank() || !(p45iter = (l4Res = l4iter.getResource()).listProperties()).hasNext()) continue;
                            StringBuffer sumns = new StringBuffer();
                            while (p45iter.hasNext()) {
                                Statement l5iter = p45iter.nextStatement();
                                String l5Pred = l5iter.getPredicate().toString();
                                Node l5Node = l5iter.getObject().asNode();
                                String[] result2 = l5Pred.split("#");
                                int i2 = result2.length - 1;
                                String name2 = this.getInpOutName(result2[i2]);
                                String[] rezNode = l5iter.getObject().toString().split(":http:");
                                String l5Nodestr = rezNode[0];
                                if (name2.equals("namespace_type_uris")) {
                                    sumns.append(l5Node + ",");
                                    continue;
                                }
                                colinp.put(name2, (String)l5Node);
                            }
                            input.put("colinp" + cin, colinp);
                            Enumeration num2 = colinp.keys();
                            Log.info("Collection input " + (++cin - 1));
                        }
                        continue;
                    }
                    System.out.println("The structure is not correct");
                    continue;
                }
                if (!l3Pred.equals((Object)MP.SecondaryArticle)) continue;
                l3Res = l3iter.getResource();
                p34iter = l3Res.listProperties();
                while (p34iter.hasNext()) {
                    String name1;
                    l4iter = p34iter.nextStatement();
                    l4Pred1 = l4iter.getPredicate().toString();
                    l4Node1 = l4iter.getObject().toString();
                    result = l4Pred1.split("#");
                    i = result.length - 1;
                    name = this.getInpOutName(result[i]);
                    rezNode1 = l4iter.getObject().toString().split(":http:");
                    l4Nodestr = rezNode1[0];
                    if (!name.equals("") || (name1 = this.getSecondaryName(result[i])).equals("")) continue;
                    if (name1.equals("enum")) {
                        secinp.remove("enum");
                        sumen.append(String.valueOf(l4Nodestr) + ",");
                        secinp.put(name1, sumen.toString());
                        System.out.println("secinp = " + secinp);
                        continue;
                    }
                    secinp.put(name1, l4Nodestr);
                    System.out.println("secinp = " + secinp);
                }
                if (secinp.isEmpty()) continue;
                input.put("secinp" + sec, secinp);
                num = secinp.keys();
                Log.info("Secondary input " + (++sec - 1));
            }
        }
        System.out.println("input= " + input);
        return input;
    }

    public Hashtable getOutput(String resource) {
        int bagout = 0;
        int so = 1;
        int co = 1;
        Hashtable output = new Hashtable();
        Resource si = this.servDescrMd.getResource(resource);
        NodeIterator ob2iter = this.servDescrMd.listObjectsOfProperty(si, MP.produces);
        while (ob2iter.hasNext()) {
            StmtIterator p23iter = ((Resource)ob2iter.next()).listProperties();
            while (p23iter.hasNext()) {
                Statement l3iter = p23iter.nextStatement();
                Property l3Pred = l3iter.getPredicate();
                Node l3Node = l3iter.getObject().asNode();
                Hashtable<String, String> simout = new Hashtable<String, String>();
                Hashtable<String, String> colout = new Hashtable<String, String>();
                StringBuffer simpns = new StringBuffer();
                StringBuffer colons = new StringBuffer();
                if (l3Pred.equals((Object)RDF.type)) {
                    bagout = 1;
                }
                if (!l3Node.isBlank()) continue;
                Resource l3Res = l3iter.getResource();
                StmtIterator p34iter = l3Res.listProperties();
                if (l3Res.hasProperty(RDF.type, (RDFNode)RDF.Bag)) {
                    bagout = 2;
                    if (l3Res.hasProperty(MP.article_name)) {
                        String col_artName = l3Res.getProperty(MP.article_name).getObject().toString();
                        String[] rezNode = col_artName.split(":http:");
                        col_artName = rezNode[0];
                        colout.put("col_articleName", col_artName);
                    }
                }
                while (p34iter.hasNext()) {
                    StmtIterator p45iter;
                    String name;
                    Statement l4iter = p34iter.nextStatement();
                    Property l4Pred = l4iter.getPredicate();
                    Node l4Node = l4iter.getObject().asNode();
                    if (l4Pred.equals((Object)RDF.type)) {
                        bagout = 2;
                    }
                    if (l4Node.isConcrete()) {
                        String l4Pred1 = l4iter.getPredicate().toString();
                        String l4Node1 = l4iter.getObject().toString();
                        String[] result = l4Pred1.split("#");
                        int i = result.length - 1;
                        if (i == 0) {
                            String[] res = l4Pred1.split("/");
                            int j = res.length - 1;
                            name = this.getInpOutName(result[i]);
                            if (name.equals("namespace_type_uris")) {
                                simpns.append(String.valueOf(l4Node1) + ",");
                            } else {
                                simout.put(name, l4Node1);
                            }
                        }
                    }
                    if (!l4Node.isBlank() || !(p45iter = l4iter.getResource().listProperties()).hasNext()) continue;
                    while (p45iter.hasNext()) {
                        int i;
                        Statement l5iter = p45iter.nextStatement();
                        String l5Pred = l5iter.getPredicate().toString();
                        String l5Node = l5iter.getObject().toString();
                        String[] result = l5Pred.split("#");
                        name = this.getInpOutName(result[i = result.length - 1]);
                        if (name.equals("namespace_type_uris")) {
                            colout.remove("namespace_type_uris");
                            colons.append(String.valueOf(l5Node) + ",");
                            colout.put(name, colons.toString());
                            continue;
                        }
                        colout.put(name, l5Node);
                    }
                    output.put("colout" + co, colout);
                    Log.info("Collection output " + (++co - 1));
                }
                if (bagout == 2) continue;
                output.put("simout" + so, simout);
                Log.info("Simple output " + (++so - 1));
            }
        }
        return output;
    }

    public String getFieldName(String name) {
        String res = "";
        if (name.equals("publisher")) {
            this.ver[0] = 1;
            res = "authURI";
        }
        if (name.equals("category")) {
            this.ver[1] = 1;
            res = "category";
        }
        if (name.equals("creator")) {
            this.ver[2] = 1;
            res = "contact_email";
        }
        if (name.equals("identifier")) {
            this.ver[3] = 1;
            res = "URL";
        }
        if (name.equals("performs_task")) {
            this.ver[4] = 1;
            res = "service_type_uri";
        }
        if (name.equals("title")) {
            this.ver[5] = 1;
            res = "servicename";
        }
        if (name.equals("description") | name.equals("comment")) {
            this.ver[6] = 1;
            res = "description";
        }
        if (name.equals("authoritative") | name.equals("coverage")) {
            this.ver[7] = 1;
            res = "authoritative";
        }
        return res;
    }

    public String getInpOutName(String name) {
        String res = "";
        if (name.equals("article_name")) {
            res = "articleName";
        }
        if (name.equals("object_type")) {
            res = "object_type_uri";
        }
        if (name.equals("namespace_type")) {
            res = "namespace_type_uris";
        }
        return res;
    }

    public String getSecondaryName(String name) {
        String res = "";
        if (name.equals("article_name")) {
            res = "article_name";
        }
        if (name.equals("default")) {
            res = "default";
        }
        if (name.equals("datatype")) {
            res = "datatype";
        }
        if (name.equals("max")) {
            res = "max";
        }
        if (name.equals("min")) {
            res = "min";
        }
        if (name.equals("enum")) {
            res = "enum";
        }
        return res;
    }
}

