/*
 * Decompiled with CFR 0.152.
 */
package ca.icapture.moby.verifier;

import ca.icapture.moby.util.DBConnector;
import ca.icapture.moby.util.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public class DataMngr {
    public static Hashtable getServices() {
        Hashtable<String, String> services = new Hashtable<String, String>();
        Connection con = DBConnector.getConnection();
        String sqlReq1 = "select servicename,signatureURL from service_instance where signatureURL != '' order by signatureURL";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = con.prepareStatement("select servicename,signatureURL from service_instance where signatureURL != '' order by signatureURL");
                rs = ps.executeQuery();
                String lastAddr = "";
                while (rs.next()) {
                    String servName = rs.getString(1);
                    String rdfAddr = rs.getString(2);
                    if (rdfAddr.equals(lastAddr)) continue;
                    lastAddr = rdfAddr;
                    services.put(servName, rdfAddr);
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var8_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return services;
    }

    public static int updService(Hashtable servSign, Hashtable servInp, Hashtable servOut, String servname, String authURI, String rdfAddr) {
        Connection con = DBConnector.getConnection();
        String servName = "";
        String cat = "moby";
        String url = "";
        String email = "";
        String desc = "";
        String stype = "";
        String authuri = "";
        String authoritative = "non-autoritative";
        String art = null;
        String col_art = null;
        String obt = "";
        String nst = "";
        String artsec = null;
        String defsec = "";
        String dtsec = "INT";
        BigDecimal maxsec = null;
        BigDecimal minsec = null;
        String enumsec = "";
        int colId = 0;
        int coloutId = 0;
        int serv = 0;
        int checkServ = 0;
        int new_serv = 0;
        int servInstId = 0;
        Enumeration num = servSign.keys();
        while (num.hasMoreElements()) {
            Object ob = num.nextElement();
            Object val = servSign.get(ob);
            if (ob.equals("category")) {
                cat = val.toString();
            }
            if (ob.equals("URL")) {
                url = val.toString();
            }
            if (ob.equals("contact_email")) {
                email = val.toString();
            }
            if (ob.equals("description")) {
                desc = val.toString();
            }
            if (ob.equals("service_type_uri")) {
                stype = val.toString();
            }
            if (ob.equals("authURI")) {
                authuri = val.toString();
            }
            if (ob.equals("authoritative")) {
                authoritative = val.toString();
            }
            if (!ob.equals("servicename")) continue;
            servName = val.toString();
            int authId = DataMngr.getAuthId(authURI);
            if (authId == 0) {
                DataMngr.insIntoAuthority(authuri, email);
                authId = DataMngr.getAuthId(authURI);
            }
            if ((servInstId = DataMngr.getServInstId(servName, authId)) != 0) continue;
            DataMngr.createSignature(servName, cat, stype, authId, url, email, authoritative, desc, rdfAddr);
            servInstId = DataMngr.getServInstId(servName, authId);
        }
        if (authuri.equals(authURI) && servName.equals(servname)) {
            serv = 1;
            DataMngr.updSign(servName, cat, stype, authuri, url, email, desc, authoritative);
        } else {
            int authId = DataMngr.getAuthId(authURI);
            checkServ = DataMngr.getServInstId(servName, authId);
            if (checkServ > 0) {
                DataMngr.updSign(servName, cat, stype, authuri, url, email, desc, authoritative);
            } else {
                int ret = DataMngr.createSignature(servName, cat, stype, authId, url, email, authoritative, desc, rdfAddr);
                if (ret == 1) {
                    Log.info("-------------The SERVICE INSTANCE **** <" + servName + "> **** ADDED IN THE DATABASE");
                    ++new_serv;
                }
            }
        }
        Enumeration num1 = servInp.keys();
        boolean dels = false;
        boolean delc = false;
        boolean delsec = false;
        while (num1.hasMoreElements()) {
            Object ob = num1.nextElement();
            Object val = servInp.get(ob);
            String simcol = ob.toString().substring(0, 6);
            if (simcol.equals("secinp")) {
                if (!delsec) {
                    DataMngr.delRow("secondary_input", "service_instance_id", servInstId);
                    delsec = true;
                }
            } else if (simcol.equals("colinp")) {
                if (!delc) {
                    DataMngr.delRow("collection_input", "service_instance_id", servInstId);
                    DataMngr.delRow("simple_input", "service_instance_id", servInstId);
                    delc = true;
                }
            } else if (!dels) {
                DataMngr.delRow("simple_input", "service_instance_id", servInstId);
                dels = true;
            }
            Hashtable simple = new Hashtable();
            simple = (Hashtable)val;
            Enumeration num11 = simple.keys();
            while (num11.hasMoreElements()) {
                Object ob1 = num11.nextElement();
                if (ob1.equals("col_articleName")) {
                    col_art = simple.get(ob1).toString();
                    if (!col_art.equals(" ")) continue;
                    col_art = null;
                    continue;
                }
                if (ob1.equals("articleName")) {
                    art = simple.get(ob1).toString();
                    if (!art.equals(" ")) continue;
                    art = null;
                    continue;
                }
                if (ob1.equals("article_name")) {
                    artsec = simple.get(ob1).toString();
                    if (!artsec.equals(" ")) continue;
                    artsec = null;
                    continue;
                }
                if (ob1.equals("object_type_uri")) {
                    obt = simple.get(ob1).toString();
                    continue;
                }
                if (ob1.equals("namespace_type_uris")) {
                    nst = simple.get(ob1).toString();
                    continue;
                }
                if (ob1.equals("default")) {
                    defsec = simple.get(ob1).toString();
                    continue;
                }
                if (ob1.equals("datatype")) {
                    dtsec = simple.get(ob1).toString();
                    continue;
                }
                if (ob1.equals("max")) {
                    String maxsec_s = simple.get(ob1).toString();
                    try {
                        maxsec = new BigDecimal(maxsec_s);
                    }
                    catch (NumberFormatException nx) {
                        Log.severe(nx.getMessage());
                    }
                    continue;
                }
                if (ob1.equals("min")) {
                    String minsec_s = simple.get(ob1).toString();
                    try {
                        minsec = new BigDecimal(minsec_s);
                    }
                    catch (NumberFormatException nx) {
                        Log.severe(nx.getMessage());
                    }
                    continue;
                }
                if (!ob1.equals("enum")) continue;
                enumsec = simple.get(ob1).toString();
            }
            if (simcol.equals("colinp")) {
                DataMngr.insIntoCol("collection_input", col_art, servInstId);
                colId = DataMngr.getCollectionId("collection_input", "collection_input_id", servInstId);
                DataMngr.addSimpleInput(servInstId, art, obt, nst, colId);
            } else if (simcol.equals("siminp")) {
                DataMngr.addSimpleInput(servInstId, art, obt, nst, 0);
            } else if (simcol.equals("secinp")) {
                DataMngr.addSecondary(servInstId, artsec, defsec, dtsec, maxsec, minsec, enumsec);
            }
            Log.info("service_instance_id: " + servInstId);
            Log.info("collection_input_id: " + colId);
        }
        Enumeration numout = servOut.keys();
        boolean delsout = false;
        boolean delcout = false;
        while (numout.hasMoreElements()) {
            Object ob = numout.nextElement();
            Object val = servOut.get(ob);
            String simcol = ob.toString().substring(0, 6);
            if (simcol.equals("colout")) {
                if (!delsout) {
                    DataMngr.delRow("collection_output", "service_instance_id", servInstId);
                    DataMngr.delRow("simple_output", "service_instance_id", servInstId);
                    delcout = true;
                }
            } else if (!delcout) {
                DataMngr.delRow("simple_output", "service_instance_id", servInstId);
                delsout = true;
            }
            Hashtable simple = new Hashtable();
            simple = (Hashtable)val;
            Enumeration num11 = simple.keys();
            while (num11.hasMoreElements()) {
                Object ob1 = num11.nextElement();
                if (ob1.equals("col_articleName") && (col_art = simple.get(ob1).toString()).equals(" ")) {
                    col_art = null;
                }
                if (ob1.equals("article_name") && (art = simple.get(ob1).toString()).equals(" ")) {
                    art = null;
                }
                if (ob1.equals("object_type_uri")) {
                    obt = simple.get(ob1).toString();
                }
                if (!ob1.equals("namespace_type_uris")) continue;
                nst = simple.get(ob1).toString();
            }
            if (simcol.equals("colout")) {
                DataMngr.insIntoCol("collection_output", "", servInstId);
                coloutId = DataMngr.getCollectionId("collection_output", "collection_output_id", servInstId);
                DataMngr.addSimpleOutput(servInstId, art, obt, nst, coloutId);
                art = null;
                obt = "";
                nst = "";
            }
            if (simcol.equals("simout")) {
                DataMngr.addSimpleOutput(servInstId, art, obt, nst, 0);
            }
            Log.info("collection_output_id: " + coloutId);
        }
        return serv;
    }

    public static void delService(String servName, String authURI) {
        int authId = DataMngr.getAuthId(authURI);
        int servInstId = DataMngr.getServInstId(servName, authId);
        DataMngr.delSignature(servName, authId);
        DataMngr.delRow("simple_input", "service_instance_id", servInstId);
        DataMngr.delRow("simple_output", "service_instance_id", servInstId);
        DataMngr.delRow("collection_input", "service_instance_id", servInstId);
        DataMngr.delRow("collection_output", "service_instance_id", servInstId);
    }

    public static void delService1(String servName, int authId) {
        int servInstId = DataMngr.getServInstId(servName, authId);
        DataMngr.delSignature(servName, authId);
        DataMngr.delRow("simple_input", "service_instance_id", servInstId);
        DataMngr.delRow("simple_output", "service_instance_id", servInstId);
        DataMngr.delRow("collection_input", "service_instance_id", servInstId);
        DataMngr.delRow("collection_output", "service_instance_id", servInstId);
    }

    public static int createSignature(String servName, String cat, String servTypeURI, int authId, String url, String email, String authoritative, String desc, String rdfAddr) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "insert into service_instance (servicename,category,service_type_uri,authority_id,url,contact_email,authoritative,description,signatureURL) values (?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("insert into service_instance (servicename,category,service_type_uri,authority_id,url,contact_email,authoritative,description,signatureURL) values (?,?,?,?,?,?,?,?,?)");
                ps.setString(1, servName);
                ps.setString(2, cat);
                ps.setString(3, servTypeURI);
                ps.setInt(4, authId);
                ps.setString(5, url);
                ps.setString(6, email);
                ps.setString(7, authoritative);
                ps.setString(8, desc);
                ps.setString(9, rdfAddr);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var14_16 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static int updSign(String servName, String cat, String stype, String authuri, String url, String email, String desc, String authoritative) {
        Connection con = DBConnector.getConnection();
        int cnt = -1;
        int ret = -1;
        String sqlReq = "select authority_id from authority where authority_uri = ?";
        PreparedStatement ps = null;
        String sqlReq1 = "update service_instance set category = ?,service_type_uri = ?,authority_id = ?,url = ?,contact_email = ?,description = ?,authoritative = ? where servicename = ?";
        try {
            try {
                ps = con.prepareStatement("select authority_id from authority where authority_uri = ?");
                ps.setString(1, authuri);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    cnt = rs.getInt(1);
                }
                if (cnt > -1) {
                    ps = con.prepareStatement("update service_instance set category = ?,service_type_uri = ?,authority_id = ?,url = ?,contact_email = ?,description = ?,authoritative = ? where servicename = ?");
                    ps.setString(1, cat);
                    ps.setString(2, stype);
                    ps.setInt(3, cnt);
                    ps.setString(4, url);
                    ps.setString(5, email);
                    ps.setString(6, desc);
                    ps.setString(7, authoritative);
                    ps.setString(8, servName);
                    ret = ps.executeUpdate();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var15_18 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static void addSimpleInput(int servInstId, String articleName, String objTypeUri, String nsTypeUris, int colInpId) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "insert into simple_input (service_instance_id,article_name,object_type_uri,namespace_type_uris,collection_input_id) values (?,?,?,?,?)";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("insert into simple_input (service_instance_id,article_name,object_type_uri,namespace_type_uris,collection_input_id) values (?,?,?,?,?)");
                ps.setInt(1, servInstId);
                ps.setString(2, articleName);
                ps.setString(3, objTypeUri);
                ps.setString(4, nsTypeUris);
                ps.setInt(5, colInpId);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var10_12 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
    }

    public static void addSecondary(int servInstId, String article_name, String def, String dataType, BigDecimal max, BigDecimal min, String string) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "insert into secondary_input (service_instance_id,article_name,default_value,maximum_value,minimum_value,enum_value,datatype) values (?,?,?,?,?,?,?)";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("insert into secondary_input (service_instance_id,article_name,default_value,maximum_value,minimum_value,enum_value,datatype) values (?,?,?,?,?,?,?)");
                ps.setInt(1, servInstId);
                ps.setString(2, article_name);
                ps.setString(3, def);
                ps.setBigDecimal(4, max);
                ps.setBigDecimal(5, min);
                ps.setString(6, string);
                ps.setString(7, dataType);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var12_14 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
    }

    public static void addSimpleOutput(int servInstId, String articleName, String objTypeUri, String nsTypeUris, int colOutId) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "insert into simple_output (service_instance_id,article_name,object_type_uri,namespace_type_uris,collection_output_id) values (?,?,?,?,?)";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("insert into simple_output (service_instance_id,article_name,object_type_uri,namespace_type_uris,collection_output_id) values (?,?,?,?,?)");
                ps.setInt(1, servInstId);
                ps.setString(2, articleName);
                ps.setString(3, objTypeUri);
                ps.setString(4, nsTypeUris);
                ps.setInt(5, colOutId);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var10_12 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
    }

    public static int getServErrorNum(String servName, int errCode) {
        int num = 0;
        Connection con = DBConnector.getConnection();
        String sqlReq1 = "select counter from service_validation where servicename = ? and error_code = ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = con.prepareStatement("select counter from service_validation where servicename = ? and error_code = ?");
                ps.setString(1, servName);
                ps.setInt(2, errCode);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int cnt;
                    num = cnt = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var8_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return num;
    }

    public static int updErrCount(String servName, int errCode) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "update service_validation set error_code = ?,counter=counter+1 where servicename = ?";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("update service_validation set error_code = ?,counter=counter+1 where servicename = ?");
                ps.setInt(1, errCode);
                ps.setString(2, servName);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var7_9 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static int insErrCount(String servName, int errCode) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "insert into service_validation (servicename,error_code,counter) values (?,?,1)";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("insert into service_validation (servicename,error_code,counter) values (?,?,1)");
                ps.setString(1, servName);
                ps.setInt(2, errCode);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var7_9 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static int delServErrors(String servName) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "delete from service_validation where servicename = ?";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("delete from service_validation where servicename = ?");
                ps.setString(1, servName);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.warning(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var6_8 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static int getServInstId(String serviceName, int authId) {
        int servInsId = 0;
        Connection con = DBConnector.getConnection();
        String sqlReq1 = "select service_instance_id from service_instance where servicename = ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = con.prepareStatement("select service_instance_id from service_instance where servicename = ?");
                ps.setString(1, serviceName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    servInsId = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var8_10 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return servInsId;
    }

    public static int delRow(String tableName, String keyName, int keyValue) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "delete from " + tableName + " where " + keyName + " = ?";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement(sqlReq1);
                ps.setInt(1, keyValue);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var8_10 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static int delSignature(String servName, int authId) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "delete from service_instance where servicename= ? and authority_id = ?";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("delete from service_instance where servicename= ? and authority_id = ?");
                ps.setString(1, servName);
                ps.setInt(2, authId);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var7_9 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static int getCollectionId(String table, String field, int servInstId) {
        int colId = 0;
        Connection con = DBConnector.getConnection();
        String sqlReq1 = "select " + field + " from " + table + " where service_instance_id = ? order by service_instance_id," + field + " ASC";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = con.prepareStatement(sqlReq1);
                ps.setInt(1, servInstId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    colId = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var9_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return colId;
    }

    public static int insIntoCol(String table, String artName, int servInstId) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "insert into " + table + " (article_name,service_instance_id) values (?,?)";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement(sqlReq1);
                ps.setString(1, artName);
                ps.setInt(2, servInstId);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var8_10 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static String getServAuthURI(String servName) {
        Connection con = DBConnector.getConnection();
        String authURI = "";
        String sqlReq1 = "select authority_uri from service_instance si,authority a where si.authority_id=a.authority_id and si.servicename=?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = con.prepareStatement("select authority_uri from service_instance si,authority a where si.authority_id=a.authority_id and si.servicename=?");
                ps.setString(1, servName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    authURI = rs.getString(1);
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var7_9 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return authURI;
    }

    public static int getServAuthId(String serviceName, String rdfAddr) {
        int authId = 0;
        Connection con = DBConnector.getConnection();
        String sqlReq1 = "select authority_id from service_instance where servicename = ? and signatureURL = ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = con.prepareStatement("select authority_id from service_instance where servicename = ? and signatureURL = ?");
                ps.setString(1, serviceName);
                ps.setString(2, rdfAddr);
                rs = ps.executeQuery();
                while (rs.next()) {
                    authId = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var8_10 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return authId;
    }

    public static int insIntoAuthority(String authURI, String email) {
        Connection con = DBConnector.getConnection();
        int ret = -1;
        String sqlReq1 = "insert into authority (authority_common_name,authority_uri,contact_email) values (null,?,?)";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement("insert into authority (authority_common_name,authority_uri,contact_email) values (null,?,?)");
                ps.setString(1, authURI);
                ps.setString(2, email);
                ret = ps.executeUpdate();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var7_9 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return ret;
    }

    public static int getAuthId(String authURI) {
        int authId = 0;
        Connection con = DBConnector.getConnection();
        String sqlReq1 = "select authority_id from authority where authority_uri = ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = con.prepareStatement("select authority_id from authority where authority_uri = ?");
                ps.setString(1, authURI);
                rs = ps.executeQuery();
                while (rs.next()) {
                    authId = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var7_9 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return authId;
    }

    public static String getContactEmail(String servName) {
        String email = "";
        Connection con = DBConnector.getConnection();
        String sqlReq1 = "select contact_email from service_instance where servicename = ? ";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = con.prepareStatement("select contact_email from service_instance where servicename = ? ");
                ps.setString(1, servName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    String cnt;
                    email = cnt = rs.getString(1);
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
            throw throwable;
        }
        Object var7_10 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return email;
    }
}

