/*
 * Decompiled with CFR 0.152.
 */
package ca.icapture.moby.verifier;

import ca.icapture.moby.util.Constants;
import ca.icapture.moby.util.Log;
import ca.icapture.moby.verifier.DataMngr;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Communicator {
    public static Model getServiceRDF(String servName, String rdfURL) {
        Model model = ModelFactory.createDefaultModel();
        try {
            URL u = new URL(rdfURL);
            HttpURLConnection huc = (HttpURLConnection)u.openConnection();
            huc.connect();
            int code = huc.getResponseCode();
            Log.info("GET ****<" + rdfURL + " >**** - HTTP CODE: " + code);
            if (code == 200 || code == 202) {
                try {
                    model.read(huc.getInputStream(), "");
                }
                catch (Exception e) {
                    Log.severe("Failed : " + e);
                }
            } else {
                int num;
                if (code == 400) {
                    Log.warning("The request had bad syntax or was inherently impossible to be satisfied.");
                }
                if (code == 401) {
                    Log.warning("The parameter to this message gives a specification of authorization schemes which are acceptable.");
                }
                if (code == 402) {
                    Log.warning("The parameter to this message gives a specification of charging schemes acceptable.");
                }
                if (code == 403) {
                    Log.warning("The request is for something forbidden. Authorization will not help.");
                }
                if (code == 404) {
                    Log.warning("The server has not found anything matching the URI given");
                }
                if (code == 500) {
                    Log.warning(" Internal Error");
                }
                if ((num = DataMngr.getServErrorNum(servName, code)) > 0) {
                    if (num < 3) {
                        DataMngr.updErrCount(servName, code);
                    } else {
                        int authId = DataMngr.getServAuthId(servName, rdfURL);
                        DataMngr.delService1(servName, authId);
                        DataMngr.delServErrors(servName);
                        Log.warning("THE SERVICE ****< " + servName + " >**** GOT HTTP CODE " + code + " THREE TIMES IN ROW ");
                        Log.warning("THE SERVICE **** < " + servName + " >**** WILL BE DELETED");
                    }
                } else {
                    DataMngr.insErrCount(servName, code);
                }
            }
            huc.disconnect();
        }
        catch (IOException e) {
            Log.severe(e.getMessage());
        }
        return model;
    }

    public static void sendMail(String to, String subj, String msgStr, String from) {
        try {
            Properties prop = new Properties();
            ((Hashtable)prop).put("mail.smtp.host", Constants.MB_MAIL_SERVER);
            Session ses = Session.getDefaultInstance((Properties)prop, null);
            MimeMessage msg = new MimeMessage(ses);
            msg.setFrom((Address)new InternetAddress(from));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            msg.setSubject(subj);
            msg.setSentDate(new Date());
            msg.setText(msgStr);
            Transport.send((Message)msg);
            Log.info("THE MESSAGE WAS SENT TO " + to);
        }
        catch (MessagingException e) {
            Log.severe(e.getMessage());
        }
    }
}

