/*
 * Decompiled with CFR 0.152.
 */
package ca.icapture.moby.util;

import ca.icapture.moby.util.Constants;
import ca.icapture.moby.util.Log;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBConnector {
    private static String url = Constants.DB_URL;
    private static String driverClassName = Constants.DB_DRIVER_CLASS;
    private static String dbUserName = Constants.DB_USER;
    private static String dbPwd = Constants.DB_PASSWD;
    public static Connection con;

    public static Connection getConnection() {
        if (con == null) {
            con = DBConnector.getNewConnection();
        } else {
            try {
                if (con.isClosed()) {
                    con = DBConnector.getNewConnection();
                }
            }
            catch (SQLException e) {
                Log.info(e.getMessage());
                con = DBConnector.getNewConnection();
            }
        }
        return con;
    }

    public static void closeConnection() {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                Log.severe(e.getMessage());
            }
        }
    }

    public static void setDBUserName(String userName) {
        dbUserName = userName;
    }

    public static void setDBPassword(String password) {
        dbPwd = password;
    }

    public static void setURL(String URL2) {
        url = URL2;
    }

    public static void setDriverClass(String driverClass) {
        driverClassName = driverClass;
    }

    private static Connection getNewConnection() {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            Log.severe(e.getMessage());
        }
        try {
            con = DriverManager.getConnection(url, dbUserName, dbPwd);
        }
        catch (SQLException e) {
            Log.severe(e.getMessage());
        }
        return con;
    }
}

